/**
 * \file: mspin_core_callback_adapter.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin CoreCallbackAdapter
 *
 * \component: MSPIN
 *
 * \author: Torsten Plate ICT-ADITG/SW2 tplate@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TPlate Initial version
 *
 ***********************************************************************/


#ifndef MSPIN_CORE_CALLBACK_ADAPTER_H_
#define MSPIN_CORE_CALLBACK_ADAPTER_H_

#include "mySPIN-Core.h"

void mspin_core_onMainThreadStart(void* context);

void mspin_core_onMainThreadEnd(void* context);

void mspin_core_onFrameUpdateStart(void *pContext, UInt8 numOfRectangles);

void mspin_core_onFrameRectUpdate(void *pContext, UInt8 currentNumber, UInt16 left, UInt16 top, UInt16 width, UInt16 height, UInt8 *pBuffer, UInt32 bufferSize);

void mspin_core_onFrameUpdateEnd(void *pContext);

void mspin_core_onPhoneCallStatus(void* context, Flag callStarts);

void mspin_core_onAppTransitionStatus(void* context, Flag transitionStarts);

void mspin_core_onAppInactive(void* context, Flag appInactive);

#if (MSPIN_IVI_CORE_VERSION < 0x01020000UL) //Not supported since IVI Core 1.2
void mspin_core_onBlockStatus(void* context, Flag isBlocked);
#else
void mspin_core_onLauncherState(void* context, LauncherState value);
void mspin_core_onAppListChanged(void* context);
void mspin_core_onAppIconResponse(void* context, AppIconResponse* appIcon);
void mspin_core_onAppStartedResponse(void* context, const char* identifierURL, AppStartStatus appStartStatus);
#endif //(MSPIN_IVI_CORE_VERSION < 0x01020000UL)

#if (MSPIN_IVI_CORE_VERSION > 0x01020300UL) //Supported since IVI Core 1.2.3
void mspin_core_onPTTAvailable(void* context, Flag pttAvailable);
#endif //(MSPIN_IVI_CORE_VERSION > 0x01020300UL)

void mspin_core_onInitiatePhoneCall(void* context, char* numberString, char* displayString);

#if (MSPIN_IVI_CORE_VERSION >= 0x01010000UL) //Supported since IVI Core 1.2
void mspin_core_onNavigateTo(void* context, char* displayString, NavigateToType type,
        double longitude, double latitude, LocationStrings* locationDesciption);

void mspin_core_onCustomString(void* context, ServerCustomDataStringType type, StringEncoding encoding, char* data);

void mspin_core_onVoiceSessionRequest(void* context, VoiceRequest requestType);

void mspin_core_onAudioRequest(void* context, AudioControl command, UInt32 requestID, AudioType type);

void mspin_core_onVehicleDataRequest(void* context, Flag request, UInt8 length, UInt32* keyList);
#else
void mspin_core_onCustomString(void* context, ServerCustomMessageType type, char* data);
#endif // (MSPIN_IVI_CORE_VERSION >= 0x01010000UL)

void mspin_core_onFrameUpdateRaw(void* context, UInt8 rectNumber, UInt16 x0, UInt16 y0, UInt16 width, UInt16 height,
        UInt8* buffer, UInt32 bufferSize, UInt8 scaleHorizontal, UInt8 scaleVertical,
        PixelFormat format, PixelEndianess endian, FrameCompression compression);

void mspin_core_onCustomInt(void* context, ServerCustomDataIntType type, UInt16 length, UInt8* data);

void mspin_core_onProtocol(void* context, eProtocolState newState);

void mspin_core_onError(void* context, eErrorCode error);

void mspin_core_onTraceOutput(void* context, eTraceClass traceClass, char* traceString);

void mspin_core_countFPS(void);

void mspin_core_updateFrameTransmissionStatus(void* context, Flag start);

#endif /* MSPIN_CORE_CALLBACK_ADAPTER_H_ */
